<?php
namespace VM\ApiBundle\DataFixtures\ORM;

use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Import\ApiBundle\Entity\AllegroCategory;
use Import\ApiBundle\Entity\AllegroCategoryItem;
use Import\ApiBundle\Entity\AllegroCategoryItemType;
use Import\ApiBundle\Entity\AllegroUser;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use VM\AdminBundle\Services\SsoCommunication;
use VM\AdminBundle\Services\TokensGenerator;
use VM\ApiBundle\Entity\Department;
use VM\ApiBundle\Entity\DepartmentAllegroCategoryItem;
use VM\ApiBundle\Entity\DepartmentType;
use VM\ApiBundle\Entity\Employee;
use VM\ApiBundle\Entity\MarketSegment;
use VM\ApiBundle\Entity\OfferReport;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;
use Import\ApiBundle\Entity\PKD;

class LoadDepartments extends AbstractFixture implements OrderedFixtureInterface, ContainerAwareInterface
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var \Doctrine\ORM\EntityManager
     */
    private $EntityManager;


    protected $segments = array(

        array(
            'name' => 'Publikacje książkowe','symbol' => 'BOOKS','pkd' => array('58.11.Z'),
            'productionCost' => 80,'energyCost'=>1.32,'maxProductionForOnePlace' => 2,'maxPrice'=>500,'currencyProductionCost'=>'PLN',
            'departments' => array(
                array('name' => 'Dział redakcji tekstów','symbol' => 'EDITORIAL','sequence'=>1,
                    'items'=>array(
                        array('symbol'=>'Komp sklad','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>20,
                        "personnel"=>"3",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"dziennikarstwo|humanistyczne",
                        "efficiency"=>"1000000",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział DTP','symbol' => 'DTP','sequence'=>2,
                    'items'=>array(
                        array('symbol'=>'Komp DTP','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>20,
                        "personnel"=>"2",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne",
                        "efficiency"=>"1000000",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział aktualizacji materiałów','symbol' => 'INNOVATIONS','sequence'=>3,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "efficiencyBiR"=>1,
                        "efficiencyType"=>"BIR",
                    )
                ),
                array('name' => 'Dział  promocji i marketingu','symbol' => 'PROMOTION','sequence'=>4,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1,"MOTO"=>1),
                        "surfaceEmployee"=>12,
                        "driver"=>"B",
                        "personnel"=>"1",
                        "efficiencyPiR"=>"1",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział sprzedaży','symbol' => 'SALE','sequence'=>5,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1,"MOTO"=>1),
                        "surfaceEmployee"=>12,
                        "driver"=>"B",
                        "personnel"=>"1",
                        "efficiencyForProduction"=>50,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
                array('name' => 'Dział finansowo księgowy','symbol' => 'FINANCIAL','sequence'=>6,
                    'items'=>array(
                        array('symbol'=>'Komp ksiegowy','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"ekonomiczno-administracyjne",
                        "efficiency"=>400,
                        "efficiencyType"=>"PROD",
                    )
                ),
            ),
            'offer_reports' => array(
                array('name' => 'Raport nieruchomości dla produkcji książek', 'code' => '52B68A', 'price' => 4000),
                array('name' => 'Raport wstępny dla produkcji książek', 'code' => '6C1FFF', 'price' => 2000),
                array('name' => 'Raport wyposażenie dla produkcji książek', 'code' => '2812FC', 'price' => 6000),
                array('name' => 'Raport zatrudnienie dla produkcji książek', 'code' => '9AB6E8', 'price' => 10000),
            )
        ),
        array(
            'name' => 'Oprogramowanie na rynek firm','symbol' => 'SOFT','pkd' => array('62.01.Z'),
            'productionCost' => 1,'energyCost'=>1.32, 'maxProductionForOnePlace' => 2.1,'maxPrice'=>1000,'currencyProductionCost'=>'PLN',
            'departments' => array(
                array('name' => 'Dział redakcji tekstów','symbol' => 'EDITORIAL','sequence'=>1,
                    'items'=>array(
                        array('symbol'=>'Komp sklad','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>20,
                        "personnel"=>"10",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"dziennikarstwo|humanistyczne",
                        "efficiency"=>"1000000",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział graficzny','symbol' => 'GRAPHIC','sequence'=>2,
                    'items'=>array(
                        array('symbol'=>'Komp DTP','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>20,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne",
                        "efficiency"=>"1000000",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział testerów','symbol' => 'TESTS','sequence'=>3,
                    'items'=>array(
                        array('symbol'=>'Komp tester','quantity'=>3),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"3",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne",
                        "efficiency"=>"1000000",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział oprogramowania','symbol' => 'SOFTWARE','sequence'=>4,
                    'items'=>array(
                        array('symbol'=>'Komp develop','quantity'=>5),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"5",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne",
                        "efficiency"=>"1000000",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział  promocji i marketingu','symbol' => 'PROMOTION','sequence'=>5,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1,"MOTO"=>1),
                        "surfaceEmployee"=>12,
                        "driver"=>"B",
                        "personnel"=>"1",
                        "efficiencyPiR"=>"1",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział sprzedaży','symbol' => 'SALE','sequence'=>6,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1,"MOTO"=>1),
                        "surfaceEmployee"=>12,
                        "driver"=>"B",
                        "personnel"=>"1",
                        "efficiencyForProduction"=>2,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
                array('name' => 'Dział finansowo księgowy','symbol' => 'FINANCIAL','sequence'=>7,
                    'items'=>array(
                        array('symbol'=>'Komp ksiegowy','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"ekonomiczno-administracyjne|prawnicze",
                        "efficiencyForProduction"=>10,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
            ),
            'offer_reports' => array(
                array('name' => 'Raport nieruchomości dla produkcji oprogramowania', 'code' => '7D9195', 'price' => 4000),
                array('name' => 'Raport wstępny dla produkcji oprogramowania', 'code' => 'C71244', 'price' => 2000),
                array('name' => 'Raport wyposażenie dla produkcji oprogramowania', 'code' => '99CE65', 'price' => 6000),
                array('name' => 'Raport zatrudnienie dla produkcji oprogramowania', 'code' => '187F74', 'price' => 10000),
            )
        ),
        array(  //tablice interaktywne
            'name' => 'Elektronika użytkowa','symbol' => 'ELECTRONICS','pkd' => array('26.11.Z'),
            'productionCost' => 2000,'energyCost'=>1.32, 'maxProductionForOnePlace' => 0.1,'maxPrice'=>20000,'currencyProductionCost'=>'PLN',
            'restrictions'=>array('minSurface'=>30,'production'=>500),
            'departments' => array(
                array('name' => 'Dział produkcji','symbol' => 'PRODUCTION','sequence'=>1,
                    'items'=>array(array('symbol'=>'Montaz','quantity'=>1)),
                    'restrictions'=>array(
                        "surfaceEquipment"=>20,
                        "personnel"=>"1|2|3",
//                        "education"=>"wyzsze|wyższe",
//                        "studies"=>"informatyczne|inżynieryjno-techniczne|produkcja i przetwórstwo",
                        "efficiency"=>"2|4|6",
                        "efficiencyType"=>"PROD",
                    ),
                ),
                array('name' => 'Dział wdrożeniowy','symbol' => 'IMPLEMENT','sequence'=>2,
                    'items'=>array(array('symbol'=>'Miernik','quantity'=>1)),
                    'restrictions'=>array(
                        "items"=>array("MOTO"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "driver"=>"B",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne|inżynieryjno-techniczne|produkcja i przetwórstwo",
                        "efficiency"=>"3",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział badań i rozwoju','symbol' => 'INNOVATIONS','sequence'=>3,
                    'items'=>array(array('symbol'=>'Komp develop','quantity'=>1)),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne|inżynieryjno-techniczne",
                        "efficiencyBiR"=>2,
                        "efficiencyType"=>"BIR",
                    )
                ),
                array('name' => 'Dział  promocji i marketingu','symbol' => 'PROMOTION','sequence'=>4,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "efficiencyPiR"=>"2",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział finansowo księgowy','symbol' => 'FINANCIAL','sequence'=>5,
                    'items'=>array(array('symbol'=>'Komp ksiegowy','quantity'=>1)),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"ekonomiczno-administracyjne|prawnicze",
                        "efficiency"=>"25",
                        "efficiencyType"=>"PROD",
                    )
                )
            ),
            'offer_reports' => array(
                array('name' => 'Raport nieruchomości dla produkcji tablic', 'code' => '73B53D', 'price' => 4000),
                array('name' => 'Raport wstępny dla produkcji tablic', 'code' => '649128', 'price' => 2000),
                array('name' => 'Raport wyposażenie dla produkcji tablic', 'code' => '6BDAA0', 'price' => 6000),
                array('name' => 'Raport zatrudnienie dla produkcji tablic', 'code' => 'E52F27', 'price' => 10000),
            )
        ),
        array(  //kuchnia Gazowo-elektryczna
            'name' => 'Sprzęt AGD','symbol' => 'AGD','pkd' => array('27.51.Z'),
            'productionCost' => 300, 'energyCost'=>1.32, 'maxProductionForOnePlace' => 20,'maxPrice'=>1500,'currencyProductionCost'=>'PLN',
            'restrictions'=>array('minSurface'=>400,'production'=>31500),
            'departments' => array(
                array('name' => 'Dział produkcji','symbol' => 'PRODUCTION','sequence'=>1,
                    'items'=>array(
                        array('symbol'=>'Wozek','quantity'=>1),
                        array('symbol'=>'Prasa','quantity'=>1),
                        array('symbol'=>'Spawanie','quantity'=>1),
                        array('symbol'=>'Lakierowanie','quantity'=>1),
                        array('symbol'=>'LiniaProd','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEquipment"=>400,
                        "personnel"=>"20|40|60|80",
                        "efficiency"=>"125|250|375|500",
                        "efficiencyType"=>"PROD",
                    ),
                ),
                array('name' => 'Dział montażu podzespołów i pakowanie','symbol' => 'MONTAGE','sequence'=>2,
                    'items'=>array(
                        array('symbol'=>'Pakowanie','quantity'=>1),
                        array('symbol'=>'Suwnica','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEquipment"=>100,
                        "personnel"=>"10|20|30|40",
                        "efficiency"=>"125|250|375|500",
                        "efficiencyType"=>"PROD",
                    ),
                ),
                array('name' => 'Dział logistyki','symbol' => 'LOGISTIC','sequence'=>3,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "studies"=>"logistyka",
                        "efficiencyForProduction"=>500,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
                array('name' => 'Dział kontroli jakości','symbol' => 'QUALITY','sequence'=>4,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "studies"=>"informatyczne|inżynieryjno-techniczne",
                        "efficiencyPiR"=>"1",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział dostaw','symbol' => 'SUPPLY','sequence'=>5,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "studies"=>"logistyka",
                        "efficiencyForProduction"=>500,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
                array('name' => 'Dział badań i rozwoju','symbol' => 'INNOVATIONS','sequence'=>6,
                    'items'=>array(
                        array('symbol'=>'Komp develop','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne|inżynieryjno-techniczne",
                        "efficiencyBiR"=>1,
                        "efficiencyType"=>"BIR",
                    )
                ),
                array('name' => 'Dział promocji i marketingu','symbol' => 'PROMOTION','sequence'=>7,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1,"MOTO"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "driver"=>"B",
                        "efficiencyPiR"=>"1",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział finansowo księgowy','symbol' => 'FINANCIAL','sequence'=>8,
                    'items'=>array(
                        array('symbol'=>'Komp ksiegowy','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"ekonomiczno-administracyjne|prawnicze",
                        "efficiency"=>500,
                        "efficiencyType"=>"PROD",
                    )
                ),
            ),
            'offer_reports' => array(
                array('name' => 'Raport nieruchomości dla produkcji szprzętu AGD', 'code' => '55EBF4', 'price' => 4000),
                array('name' => 'Raport wstępny dla produkcji szprzętu AGD', 'code' => 'FE4D0A', 'price' => 2000),
                array('name' => 'Raport wyposażenie dla produkcji szprzętu AGD', 'code' => 'B7600A', 'price' => 6000),
                array('name' => 'Raport zatrudnienie dla produkcji szprzętu AGD', 'code' => '37529E', 'price' => 10000),
            )
        ),
        array(  //siedziska samochodowe
            'name' => 'Komponenty do produkcji samochodów','symbol' => 'AUTO','pkd' => array('29.32.Z'),
            'productionCost' => 10,'energyCost'=>1.32, 'maxProductionForOnePlace' => 10,'maxPrice'=>300,'currencyProductionCost'=>'EUR',
            'restrictions'=>array('minSurface'=>300,'production'=>25200),
            'departments' => array(
                array('name' => 'Dział produkcji','symbol' => 'PRODUCTION','sequence'=>1,
                    'items'=>array(
                        array('symbol'=>'Wozek','quantity'=>2),
                        array('symbol'=>'Prasa','quantity'=>1),
                        array('symbol'=>'Spawanie','quantity'=>1),
                        array('symbol'=>'Lakierowanie','quantity'=>3),
                        array('symbol'=>'TasmaProd','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEquipment"=>300,
                        "personnel"=>"22|44|66|88",
//                        "education"=>"wyzsze|wyższe",
//                        "studies"=>"informatyczne|inżynieryjno-techniczne|produkcja i przetwórstwo",
                        "efficiency"=>"100|200|300|400",
                        "efficiencyType"=>"PROD",
                    )
                ),
                array('name' => 'Dział logistyki','symbol' => 'LOGISTIC','sequence'=>2,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "studies"=>"logistyka",
                        "efficiencyForProduction"=>400,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
                array('name' => 'Dział kontroli jakości','symbol' => 'QUALITY','sequence'=>3,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "studies"=>"inżynieryjno-techniczne",
                        "efficiencyPiR"=>"1",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział dostaw','symbol' => 'SUPPLY','sequence'=>4,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "studies"=>"logistyka",
                        "efficiencyForProduction"=>200,
                        "efficiencyType"=>"FOR_PROD",
                    )
                ),
                array('name' => 'Dział badań i rozwoju','symbol' => 'INNOVATIONS','sequence'=>5,
                    'items'=>array(
                        array('symbol'=>'Komp develop','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"informatyczne|inżynieryjno-techniczne",
                        "efficiencyBiR"=>1,
                        "efficiencyType"=>"BIR",
                    )
                ),
                array('name' => 'Dział promocji i marketingu','symbol' => 'PROMOTION','sequence'=>6,
                    'restrictions'=>array(
                        "items"=>array("KOMP"=>1),
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "efficiencyPiR"=>"1",
                        "efficiencyType"=>"PIR",
                    )
                ),
                array('name' => 'Dział finansowo księgowy','symbol' => 'FINANCIAL','sequence'=>7,
                    'items'=>array(
                        array('symbol'=>'Komp ksiegowy','quantity'=>1),
                    ),
                    'restrictions'=>array(
                        "surfaceEmployee"=>12,
                        "personnel"=>"1",
                        "education"=>"wyzsze|wyższe",
                        "studies"=>"ekonomiczno-administracyjne|prawnicze",
                        "efficiency"=>200,
                        "efficiencyType"=>"PROD",
                    )
                ),
            ),
            'offer_reports' => array(
                array('name' => 'Raport nieruchomości dla produkcji siedzisk samochodowych', 'code' => 'B338AF', 'price' => 4000),
                array('name' => 'Raport wstępny dla produkcji siedzisk samochodowych', 'code' => 'A21D74', 'price' => 2000),
                array('name' => 'Raport wyposażenie dla produkcji siedzisk samochodowych', 'code' => '426132', 'price' => 6000),
                array('name' => 'Raport zatrudnienie dla produkcji siedzisk samochodowych', 'code' => 'B83469', 'price' => 10000),
            )
        )
    );


    protected $types = array(
        array('name' => 'Produkcja', 'symbol' => 'PRODUCTION'),
        array('name' => 'Badanie i rozwój', 'symbol' => 'INNOVATIONS'),
        array('name' => 'Promocja i marketing', 'symbol' => 'PROMOTION'),
        array('name' => 'Wdrożenie','symbol' => 'IMPLEMENT'),
        array('name' => 'Finanse', 'symbol' => 'FINANCIAL'),
        array('name' => 'Logistyka', 'symbol' => 'LOGISTIC'),
        array('name' => 'Kontrola jakości', 'symbol' => 'QUALITY'),
        array('name' => 'Dostawy', 'symbol' => 'SUPPLY'),
        array('name' => 'Montaż i pakowanie', 'symbol' => 'MONTAGE'),
        array('name' => 'Redakcja tekstów', 'symbol' => 'EDITORIAL'),
        array('name' => 'DTP', 'symbol' => 'DTP'),
        array('name' => 'Sprzedaż', 'symbol' => 'SALE'),
        array('name' => 'Grafika', 'symbol' => 'GRAPHIC'),
        array('name' => 'Testerzy', 'symbol' => 'TESTS'),
        array('name' => 'Oprogramowanie', 'symbol' => 'SOFTWARE'),
        array('name' => 'Inne', 'symbol' => 'OTHERS')
    );

    private $allegroCategoryItems = array(
        'Montaz' => array('name'=>'Stanowisko montażowe','buy_now_price'=>5000,'type_symbol'=>'OTHER'),
        'Miernik' => array('name'=>'Zestaw mierników','buy_now_price'=>5000,'type_symbol'=>'OTHER'),
        'Komp develop' => array('name'=>'DELL Vostro 3460 z oprogramowaniem developerskim','buy_now_price'=>10000,'type_symbol'=>'KOMP'),
        'Komp tester' => array('name'=>'DELL Vostro 5370 z oprogramowaniem do testów','buy_now_price'=>10000,'type_symbol'=>'KOMP'),
        'Komp ksiegowy' => array('name'=>'HP dc9900 z oprogramowaniem księgowym','buy_now_price'=>4000,'type_symbol'=>'KOMP'),
        'Komp sklad' => array('name'=>'HP dc7900 z oprogramowaniem do składu','buy_now_price'=>5000,'type_symbol'=>'KOMP'),
        'Komp DTP' => array('name'=>'HP dc4900 z oprogramowaniem DTP','buy_now_price'=>15000,'type_symbol'=>'KOMP'),
        'Wozek' => array('name'=>'Wózek widłowy','buy_now_price'=>50000,'type_symbol'=>'OTHER'),
        'Prasa' => array('name'=>'Prasa do tłoczenia','buy_now_price'=>8000,'type_symbol'=>'OTHER'),
        'Spawanie' => array('name'=>'Kabina spawalnicza','buy_now_price'=>9000,'type_symbol'=>'OTHER',),
        'Lakierowanie' => array('name'=>'Maszyna lakiernicza','buy_now_price'=>12000,'type_symbol'=>'OTHER'),
        'TasmaProd' => array('name'=>'Taśma produkcyjna','buy_now_price'=>55000,'type_symbol'=>'OTHER'),
        'LiniaProd' => array('name'=>'Linia produkcyjna','buy_now_price'=>100000,'type_symbol'=>'OTHER'),
        'Pakowanie' => array('name'=>'Urządzenie do pakowania','buy_now_price'=>60000,'type_symbol'=>'OTHER'),
        'Suwnica' => array('name'=>'Mała suwnica','buy_now_price'=>60000,'type_symbol'=>'OTHER'),
    );

    private $activePkdList = array(
        '26.11.Z','26.12.Z','26.20.Z','26.30.Z','26.40.Z','27.11.Z','27.12.Z','27.20.Z','29.10.A','29.10.B','29.10.C',
        '29.10.D','29.10.E','29.20.Z','29.31.Z','29.32.Z','30.11.Z','30.12.Z','30.30.Z','30.40.Z','30.40.Z','30.92.Z',
        '30.99.Z','27.51.Z','27.52.Z','27.90.Z','58.11.Z','58.12.Z','58.13.Z','58.14.Z','58.19.Z','58.21.Z','58.29.Z',
        '59.11.Z','59.12.Z','59.13.Z','59.14.Z','59.20.Z','62.01.Z','62.02.Z','62.03.Z','62.09.Z',
    );

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }


    public function load(ObjectManager $EntityManager)
    {
        $this->EntityManager = $EntityManager;


        echo 'Load KodesPKD.'."\r\n";
        $importPKD = $this->container->get('import_pkd');
        $importPKD->import();

        foreach($this->activePkdList as $pkdSymbol)
        {
            $Pkd = $this->getPkd($pkdSymbol);
            if(!empty($Pkd))
            {
                $Pkd->setActive(1);
            }
        }

        foreach($this->types as $type)
        {
            $DepartmentType = new DepartmentType();
            $DepartmentType->setName($type['name']);
            $DepartmentType->setSymbol($type['symbol']);

            $this->EntityManager->persist($DepartmentType);
            $this->addReference('department_type_' . $type['symbol'], $DepartmentType);
        }

        foreach($this->allegroCategoryItems as $symbol => $itemData)
        {
            $Item = new AllegroCategoryItem();

            $Item->setCategory($this->getAllegroCategory(7736));

            $Item->setName($itemData['name']);
            $Item->setBuyNowPrice($itemData['buy_now_price']);

            $Item->setType($this->getAllegroCategoryItemTypeSymbol($itemData['type_symbol']));
            $Item->setUser($this->getAllegroUser(1));
            $Item->setItemId(3681422222);
            $Item->setEndingTime(new \DateTime('2013-12-03 13:23:25'));
            $Item->setCity('Rzeszów');
            $Item->setState(9);
            $Item->setCountry(1);
            $Item->setThumbUrl('');
            $Item->setPeriodOfNotice(0);
            $Item->setBail(0);
            $Item->setSurface(1);
            $Item->setIdInAdvertService('21522222');

            $this->EntityManager->persist($Item);
            $this->addReference('item_' . $symbol, $Item);
        }

        foreach($this->segments as $segment)
        {
            $MarketSegment = new MarketSegment();
            $MarketSegment->setName($segment['name']);
            $MarketSegment->setProductionCost($segment['productionCost']);
            $MarketSegment->setMaxProductionForOnePlace($segment['maxProductionForOnePlace']);
            $MarketSegment->setSymbol($segment['symbol']);
            $MarketSegment->setEnergyCost(isset($segment['energyCost'])?$segment['energyCost']:0);
            if(isset($segment['restrictions']))
            {
                $MarketSegment->setRestrictions(json_encode($segment['restrictions'],true));
            }
            if(isset($segment['currencyProductionCost']))
            {
                $MarketSegment->setCurrencyProductionCost($segment['currencyProductionCost']);
            }
            if(isset($segment['maxPrice']))
            {
                $MarketSegment->setMaxPrice($segment['maxPrice']);
            }

            foreach($segment['offer_reports'] as $reportData)
            {
                $OfferReport = new OfferReport();
                $OfferReport->setMarketSegment($MarketSegment);
                $OfferReport->setName($reportData['name']);
                $OfferReport->setCode($reportData['code']);
                $OfferReport->setPrice($reportData['price']);

                $EntityManager->persist($OfferReport);
            }

            foreach($segment['pkd'] as $symbol)
            {
                $Pkd = $this->getPkd($symbol);
                $MarketSegment->addCodesPkd($Pkd);
                $Pkd->setMarketSegment($MarketSegment);
            }

            foreach($segment['departments'] as $departmentData)
            {
                $Department = new Department();
                $Department->setMarketSegment($MarketSegment);
                $Department->setName($departmentData['name']);
                $Department->setSequence($departmentData['sequence']);
                $Department->setType($this->getReference('department_type_' . $departmentData['symbol']));
                if(isset($departmentData['restrictions']))
                {
                    $Department->setRestrictions(json_encode($departmentData['restrictions'],true));
                }

                if(isset($departmentData['items']))
                {
                    foreach($departmentData['items'] as $itemData)
                    {
                        $DepartmentAllegroCategoryItem = new DepartmentAllegroCategoryItem();

                        $DepartmentAllegroCategoryItem->setDepartment($Department);
                        $DepartmentAllegroCategoryItem->setItem($this->getReference('item_' . $itemData['symbol']));
                        $DepartmentAllegroCategoryItem->setQuantity($itemData['quantity']);

                        $this->EntityManager->persist($DepartmentAllegroCategoryItem);
                    }
                }

                $this->EntityManager->persist($Department);
            }

            $EntityManager->persist($MarketSegment);
        }

        $this->EntityManager->flush();
    }


    /**
     * @param $symbol
     * @return PKD
     */
    private function getPkd($symbol)
    {
        return $this->EntityManager->getRepository('ImportApiBundle:PKD')->findOneBy(array('symbol' => $symbol));
    }

    /**
     * @param $id
     * @return AllegroCategory
     */
    private function getAllegroCategory($id)
    {
        return $this->EntityManager->getRepository('ImportApiBundle:AllegroCategory')->find($id);
    }

    /**
     * @param $symbol
     * @return AllegroCategoryItemType
     */
    private function getAllegroCategoryItemTypeSymbol($symbol)
    {
        return $this->EntityManager->getRepository('ImportApiBundle:AllegroCategoryItemType')->findOneBy(array('symbol'=>$symbol));
    }

    /**
     * @param $id
     * @return AllegroUser
     */
    private function getAllegroUser($id)
    {
        return $this->EntityManager->getRepository('ImportApiBundle:AllegroUser')->find($id);
    }


    public function getOrder()
    {
        return 1100;
    }
}